/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.desktop.win;

import com.btr.proxy.search.desktop.win.Win32ProxyUtils;
import com.btr.proxy.util.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class DLLManager {
    public static final String LIB_DIR_OVERRIDE = "proxy_vole_lib_dir";
    static final String TEMP_FILE_PREFIX = "proxy_vole";
    static final String DLL_EXTENSION = ".dll";
    static String LIB_NAME_BASE = "proxy_util_";
    static final String DEFAULT_LIB_FOLDER = "lib";

    DLLManager() {
    }

    static File findLibFile() throws IOException {
        String libName = DLLManager.buildLibName();
        File libFile = DLLManager.getOverrideLibFile(libName);
        if (libFile == null || !libFile.exists()) {
            libFile = DLLManager.getDefaultLibFile(libName);
        }
        if (libFile == null || !libFile.exists()) {
            libFile = DLLManager.extractToTempFile(libName);
        }
        return libFile;
    }

    static void cleanupTempFiles() {
        try {
            String tempFolder = System.getProperty("java.io.tmpdir");
            if (tempFolder == null || tempFolder.trim().length() == 0) {
                return;
            }
            File fldr = new File(tempFolder);
            File[] oldFiles = fldr.listFiles(new TempDLLFileFilter());
            if (oldFiles == null) {
                return;
            }
            for (File tmp : oldFiles) {
                tmp.delete();
            }
        }
        catch (Exception e) {
            Logger.log(DLLManager.class, Logger.LogLevel.DEBUG, "Error cleaning up temporary dll files. ", e);
        }
    }

    private static File getDefaultLibFile(String libName) {
        return new File(DEFAULT_LIB_FOLDER, libName);
    }

    private static File getOverrideLibFile(String libName) {
        String libDir = System.getProperty(LIB_DIR_OVERRIDE);
        if (libDir == null || libDir.trim().length() == 0) {
            return null;
        }
        return new File(libDir, libName);
    }

    static File extractToTempFile(String libName) throws IOException {
        InputStream source = Win32ProxyUtils.class.getResourceAsStream("/lib/" + libName);
        File tempFile = File.createTempFile(TEMP_FILE_PREFIX, DLL_EXTENSION);
        tempFile.deleteOnExit();
        FileOutputStream destination = new FileOutputStream(tempFile);
        DLLManager.copy(source, destination);
        return tempFile;
    }

    private static void closeStream(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream source, OutputStream dest) throws IOException {
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            while (read >= 0) {
                dest.write(buffer, 0, read);
                read = source.read(buffer);
            }
            dest.flush();
        }
        finally {
            DLLManager.closeStream(source);
            DLLManager.closeStream(dest);
        }
    }

    private static String buildLibName() {
        String arch = "w32";
        if (!System.getProperty("os.arch").equals("x86")) {
            arch = System.getProperty("os.arch");
        }
        return LIB_NAME_BASE + arch + DLL_EXTENSION;
    }

    private static final class TempDLLFileFilter
    implements FileFilter {
        private TempDLLFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return pathname.isFile() && name.startsWith(DLLManager.TEMP_FILE_PREFIX) && name.endsWith(DLLManager.DLL_EXTENSION);
        }
    }
}

