/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util.vm;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.util.Util;
import org.openslx.util.vm.UnsupportedVirtualizerFormatException;
import org.openslx.util.vm.VmMetaData;
import org.openslx.util.vm.VmWareDDAccelMeta;
import org.openslx.util.vm.VmWareEthernetDevTypeMeta;
import org.openslx.util.vm.VmWareHWVersionMeta;
import org.openslx.util.vm.VmWareSoundCardMeta;
import org.openslx.util.vm.VmwareConfig;

public class VmwareMetaData
extends VmMetaData<VmWareSoundCardMeta, VmWareDDAccelMeta, VmWareHWVersionMeta, VmWareEthernetDevTypeMeta> {
    private static final Logger LOGGER = Logger.getLogger(VmwareMetaData.class);
    private static final Virtualizer virtualizer = new Virtualizer("vmware", "VMware");
    private static final Pattern hddKey = Pattern.compile("^(ide\\d|scsi\\d|sata\\d):?(\\d)?\\.(.*)", 2);
    private static final Pattern[] whitelist;
    private final VmwareConfig config;
    private final Map<String, Controller> disks = new HashMap<String, Controller>();

    public VmwareMetaData(List<OperatingSystem> osList, File file) throws IOException, UnsupportedVirtualizerFormatException {
        super(osList);
        this.config = new VmwareConfig(file);
        this.init();
    }

    public VmwareMetaData(List<OperatingSystem> osList, byte[] vmxContent, int length) throws UnsupportedVirtualizerFormatException {
        super(osList);
        this.config = new VmwareConfig(vmxContent, length);
        this.init();
    }

    private void init() {
        this.registerVirtualHW();
        for (Map.Entry<String, VmwareConfig.ConfigEntry> entry : this.config.entrySet()) {
            this.handleLoadEntry(entry);
        }
        if (this.config.get("#SLX_HDD_BUS") != null) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.disks.entrySet()) {
            Controller controller = (Controller)entry.getValue();
            String controllerType = entry.getKey();
            if (!controller.present) continue;
            for (Map.Entry<String, Device> dEntry : controller.devices.entrySet()) {
                Device device = dEntry.getValue();
                if (!device.present || device.deviceType != null && !device.deviceType.toLowerCase().endsWith("disk")) continue;
                VmMetaData.DriveBusType bus = null;
                if (controllerType.startsWith("ide")) {
                    bus = VmMetaData.DriveBusType.IDE;
                } else if (controllerType.startsWith("scsi")) {
                    bus = VmMetaData.DriveBusType.SCSI;
                } else if (controllerType.startsWith("sata")) {
                    bus = VmMetaData.DriveBusType.SATA;
                }
                this.hdds.add(new VmMetaData.HardDisk(controller.virtualDev, bus, device.filename));
            }
        }
        this.isMachineSnapshot = false;
        if (!this.hdds.isEmpty()) {
            VmMetaData.HardDisk hdd = (VmMetaData.HardDisk)this.hdds.get(0);
            this.addFiltered("#SLX_HDD_BUS", hdd.bus.toString());
            if (hdd.chipsetDriver != null) {
                this.addFiltered("#SLX_HDD_CHIP", hdd.chipsetDriver);
            }
        }
    }

    private void addFiltered(String key, String value) {
        this.config.set(key, value).filtered(true);
    }

    private boolean isSetAndTrue(String key) {
        String value = this.config.get(key);
        return value != null && value.equalsIgnoreCase("true");
    }

    private void handleLoadEntry(Map.Entry<String, VmwareConfig.ConfigEntry> entry) {
        String lowerKey = entry.getKey().toLowerCase();
        for (Pattern exp : whitelist) {
            if (!exp.matcher(lowerKey).find()) continue;
            entry.getValue().filtered(true);
            break;
        }
        String value = entry.getValue().getValue();
        if (lowerKey.equals("guestos")) {
            this.setOs(value);
            return;
        }
        if (lowerKey.equals("displayname")) {
            this.displayName = value;
            return;
        }
        Matcher hdd = hddKey.matcher(entry.getKey());
        if (hdd.find()) {
            this.handleHddEntry(hdd.group(1).toLowerCase(), hdd.group(2), hdd.group(3), value);
        }
    }

    private void handleHddEntry(String controllerStr, String deviceStr, String property, String value) {
        Controller controller = this.disks.get(controllerStr);
        if (controller == null) {
            controller = new Controller();
            this.disks.put(controllerStr, controller);
        }
        if (deviceStr == null || deviceStr.isEmpty()) {
            if (property.equalsIgnoreCase("present")) {
                controller.present = Boolean.parseBoolean(value);
            } else if (property.equalsIgnoreCase("virtualDev")) {
                controller.virtualDev = value;
            }
            return;
        }
        Device device = controller.devices.get(deviceStr);
        if (device == null) {
            device = new Device();
            controller.devices.put(deviceStr, device);
        }
        if (property.equalsIgnoreCase("deviceType")) {
            device.deviceType = value;
        } else if (property.equalsIgnoreCase("filename")) {
            device.filename = value;
        } else if (property.equalsIgnoreCase("present")) {
            device.present = Boolean.parseBoolean(value);
        }
    }

    @Override
    public boolean addHddTemplate(File diskImage, String hddMode, String redoDir) {
        return this.addHddTemplate(diskImage.getName(), hddMode, redoDir);
    }

    @Override
    public boolean addHddTemplate(String diskImagePath, String hddMode, String redoDir) {
        String prefix;
        VmMetaData.DriveBusType bus;
        if (diskImagePath.isEmpty()) {
            LOGGER.error("Empty disk image path given!");
            return false;
        }
        try {
            bus = VmMetaData.DriveBusType.valueOf(this.config.get("#SLX_HDD_BUS"));
        }
        catch (Exception e) {
            LOGGER.warn("Unknown bus type: " + this.config.get("#SLX_HDD_BUS") + ". Cannot add hdd config.");
            return false;
        }
        String chipset = this.config.get("#SLX_HDD_CHIP");
        switch (bus) {
            case IDE: {
                prefix = "ide0:0";
                this.addFiltered("ide0.present", "TRUE");
                break;
            }
            case SATA: 
            case SCSI: {
                prefix = "scsi0:0";
                this.addFiltered("scsi0.present", "TRUE");
                if (chipset == null) break;
                this.addFiltered("scsi0.virtualDev", chipset);
                break;
            }
            default: {
                LOGGER.warn("Unknown HDD bus type: " + bus.toString());
                return false;
            }
        }
        this.addFiltered(prefix + ".present", "TRUE");
        this.addFiltered(prefix + ".deviceType", "disk");
        this.addFiltered(prefix + ".fileName", diskImagePath);
        if (hddMode != null) {
            this.addFiltered(prefix + ".mode", hddMode);
            this.addFiltered(prefix + ".redo", "");
            this.addFiltered(prefix + ".redoLogDir", redoDir);
        }
        this.config.remove("#SLX_HDD_BUS");
        this.config.remove("#SLX_HDD_CHIP");
        return true;
    }

    @Override
    public boolean addDefaultNat() {
        this.addFiltered("ethernet0.present", "TRUE");
        this.addFiltered("ethernet0.connectionType", "nat");
        return true;
    }

    @Override
    public boolean addEthernet(VmMetaData.EtherType type) {
        boolean ret = false;
        int index = 0;
        while (this.config.get("ethernet" + index + ".present") != null) {
            ++index;
        }
        switch (type) {
            case NAT: {
                ret = this.addEthernet(index, EthernetType.NAT);
                break;
            }
            case BRIDGED: {
                ret = this.addEthernet(index, EthernetType.BRIDGED);
                break;
            }
            case HOST_ONLY: {
                ret = this.addEthernet(index, EthernetType.HOST_ONLY);
                break;
            }
        }
        return ret;
    }

    public boolean addEthernet(int index, EthernetType type) {
        String dev;
        String ether = "ethernet" + index;
        this.addFiltered(ether + ".present", "TRUE");
        this.addFiltered(ether + ".connectionType", "custom");
        this.addFiltered(ether + ".vnet", type.vmnet);
        if (this.config.get(ether + ".virtualDev") == null && (dev = this.config.get("ethernet0.virtualDev")) != null) {
            this.addFiltered(ether + ".virtualDev", dev);
        }
        return true;
    }

    @Override
    public void addFloppy(int index, String image, boolean readOnly) {
        String pre = "floppy" + index;
        this.addFiltered(pre + ".present", "TRUE");
        if (image == null) {
            this.addFiltered(pre + ".startConnected", "FALSE");
            this.addFiltered(pre + ".fileType", "device");
            this.config.remove(pre + ".fileName");
            this.config.remove(pre + ".readonly");
            this.addFiltered(pre + ".autodetect", "TRUE");
        } else {
            this.addFiltered(pre + ".startConnected", "TRUE");
            this.addFiltered(pre + ".fileType", "file");
            this.addFiltered(pre + ".fileName", image);
            this.addFiltered(pre + ".readonly", VmwareMetaData.vmBoolean(readOnly));
            this.config.remove(pre + ".autodetect");
        }
    }

    @Override
    public boolean addCdrom(String image) {
        for (String port : new String[]{"ide0:0", "ide0:1", "ide1:0", "ide1:1", "scsi0:1"}) {
            if (this.isSetAndTrue(port + ".present")) continue;
            this.addFiltered(port + ".present", "TRUE");
            if (image == null) {
                this.addFiltered(port + ".autodetect", "TRUE");
                this.addFiltered(port + ".deviceType", "cdrom-raw");
                this.config.remove(port + ".fileName");
            } else {
                this.config.remove(port + ".autodetect");
                this.addFiltered(port + ".deviceType", "cdrom-image");
                this.addFiltered(port + ".fileName", image);
            }
            return true;
        }
        return false;
    }

    private static String vmBoolean(boolean var) {
        return Boolean.toString(var).toUpperCase();
    }

    private static String vmInteger(int val) {
        return Integer.toString(val);
    }

    @Override
    public boolean disableSuspend() {
        this.addFiltered("suspend.disabled", "TRUE");
        return true;
    }

    @Override
    public boolean addDisplayName(String name) {
        this.addFiltered("displayName", name);
        return true;
    }

    @Override
    public boolean addRam(int mem) {
        this.addFiltered("memsize", Integer.toString(mem));
        return true;
    }

    @Override
    public void setOs(String vendorOsId) {
        this.addFiltered("guestOS", vendorOsId);
        this.setOs("vmware", vendorOsId);
    }

    @Override
    public byte[] getFilteredDefinitionArray() {
        return this.config.toString(true, false).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getDefinitionArray() {
        return this.config.toString(false, false).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Virtualizer getVirtualizer() {
        return virtualizer;
    }

    @Override
    public void enableUsb(boolean enabled) {
        this.addFiltered("usb.present", VmwareMetaData.vmBoolean(enabled));
        this.addFiltered("ehci.present", VmwareMetaData.vmBoolean(enabled));
    }

    @Override
    public void applySettingsForLocalEdit() {
        this.addFiltered("gui.applyHostDisplayScalingToGuest", "FALSE");
    }

    public String getValue(String key) {
        return this.config.get(key);
    }

    @Override
    public void setSoundCard(VmMetaData.SoundCardType type) {
        VmWareSoundCardMeta soundCardMeta = (VmWareSoundCardMeta)this.soundCards.get((Object)type);
        this.addFiltered("sound.present", VmwareMetaData.vmBoolean(soundCardMeta.isPresent));
        if (soundCardMeta.value != null) {
            this.addFiltered("sound.virtualDev", soundCardMeta.value);
        } else {
            this.config.remove("sound.virtualDev");
        }
    }

    @Override
    public VmMetaData.SoundCardType getSoundCard() {
        if (!this.isSetAndTrue("sound.present") || !this.isSetAndTrue("sound.autodetect")) {
            return VmMetaData.SoundCardType.NONE;
        }
        String current = this.config.get("sound.virtualDev");
        if (current != null) {
            VmWareSoundCardMeta soundCardMeta = null;
            for (VmMetaData.SoundCardType type : VmMetaData.SoundCardType.values()) {
                soundCardMeta = (VmWareSoundCardMeta)this.soundCards.get((Object)type);
                if (soundCardMeta == null || !current.equals(soundCardMeta.value)) continue;
                return type;
            }
        }
        return VmMetaData.SoundCardType.DEFAULT;
    }

    @Override
    public void setDDAcceleration(VmMetaData.DDAcceleration type) {
        VmWareDDAccelMeta ddaMeta = (VmWareDDAccelMeta)this.ddacc.get((Object)type);
        this.addFiltered("mks.enable3d", VmwareMetaData.vmBoolean(ddaMeta.isPresent));
    }

    @Override
    public VmMetaData.DDAcceleration getDDAcceleration() {
        if (this.isSetAndTrue("mks.enable3d")) {
            return VmMetaData.DDAcceleration.ON;
        }
        return VmMetaData.DDAcceleration.OFF;
    }

    @Override
    public void setHWVersion(VmMetaData.HWVersion type) {
        VmWareHWVersionMeta hwVersionMeta = (VmWareHWVersionMeta)this.hwversion.get((Object)type);
        this.addFiltered("virtualHW.version", VmwareMetaData.vmInteger(hwVersionMeta.version));
    }

    @Override
    public VmMetaData.HWVersion getHWVersion() {
        int currentValue = Util.parseInt(this.config.get("virtualHW.version"), -1);
        VmWareHWVersionMeta hwVersionMeta = null;
        for (VmMetaData.HWVersion ver : VmMetaData.HWVersion.values()) {
            hwVersionMeta = (VmWareHWVersionMeta)this.hwversion.get((Object)ver);
            if (hwVersionMeta == null || currentValue != hwVersionMeta.version) continue;
            return ver;
        }
        return VmMetaData.HWVersion.NONE;
    }

    @Override
    public void setEthernetDevType(int cardIndex, VmMetaData.EthernetDevType type) {
        VmWareEthernetDevTypeMeta ethernetDevTypeMeta = (VmWareEthernetDevTypeMeta)this.networkCards.get((Object)type);
        if (ethernetDevTypeMeta.value != null) {
            this.addFiltered("ethernet" + cardIndex + ".virtualDev", ethernetDevTypeMeta.value);
        } else {
            this.config.remove("ethernet" + cardIndex + ".virtualDev");
        }
    }

    @Override
    public VmMetaData.EthernetDevType getEthernetDevType(int cardIndex) {
        String temp = this.config.get("ethernet" + cardIndex + ".virtualDev");
        if (temp != null) {
            VmWareEthernetDevTypeMeta ethernetDevTypeMeta = null;
            for (VmMetaData.EthernetDevType type : VmMetaData.EthernetDevType.values()) {
                ethernetDevTypeMeta = (VmWareEthernetDevTypeMeta)this.networkCards.get((Object)type);
                if (ethernetDevTypeMeta == null || !temp.equals(ethernetDevTypeMeta.value)) continue;
                return type;
            }
        }
        return VmMetaData.EthernetDevType.AUTO;
    }

    @Override
    public boolean addCpuCoreCount(int numCores) {
        return false;
    }

    @Override
    public void registerVirtualHW() {
        this.soundCards.put(VmMetaData.SoundCardType.NONE, new VmWareSoundCardMeta(false, null));
        this.soundCards.put(VmMetaData.SoundCardType.DEFAULT, new VmWareSoundCardMeta(true, null));
        this.soundCards.put(VmMetaData.SoundCardType.SOUND_BLASTER, new VmWareSoundCardMeta(true, "sb16"));
        this.soundCards.put(VmMetaData.SoundCardType.ES, new VmWareSoundCardMeta(true, "es1371"));
        this.soundCards.put(VmMetaData.SoundCardType.HD_AUDIO, new VmWareSoundCardMeta(true, "hdaudio"));
        this.ddacc.put(VmMetaData.DDAcceleration.OFF, new VmWareDDAccelMeta(false));
        this.ddacc.put(VmMetaData.DDAcceleration.ON, new VmWareDDAccelMeta(true));
        this.hwversion.put(VmMetaData.HWVersion.NONE, new VmWareHWVersionMeta(0));
        this.hwversion.put(VmMetaData.HWVersion.THREE, new VmWareHWVersionMeta(3));
        this.hwversion.put(VmMetaData.HWVersion.FOUR, new VmWareHWVersionMeta(4));
        this.hwversion.put(VmMetaData.HWVersion.SIX, new VmWareHWVersionMeta(6));
        this.hwversion.put(VmMetaData.HWVersion.SEVEN, new VmWareHWVersionMeta(7));
        this.hwversion.put(VmMetaData.HWVersion.EIGHT, new VmWareHWVersionMeta(8));
        this.hwversion.put(VmMetaData.HWVersion.NINE, new VmWareHWVersionMeta(9));
        this.hwversion.put(VmMetaData.HWVersion.TEN, new VmWareHWVersionMeta(10));
        this.hwversion.put(VmMetaData.HWVersion.ELEVEN, new VmWareHWVersionMeta(11));
        this.hwversion.put(VmMetaData.HWVersion.TWELVE, new VmWareHWVersionMeta(12));
        this.networkCards.put(VmMetaData.EthernetDevType.AUTO, new VmWareEthernetDevTypeMeta(null));
        this.networkCards.put(VmMetaData.EthernetDevType.PCNET32, new VmWareEthernetDevTypeMeta("vlance"));
        this.networkCards.put(VmMetaData.EthernetDevType.E1000, new VmWareEthernetDevTypeMeta("e1000"));
        this.networkCards.put(VmMetaData.EthernetDevType.E1000E, new VmWareEthernetDevTypeMeta("e1000e"));
        this.networkCards.put(VmMetaData.EthernetDevType.VMXNET, new VmWareEthernetDevTypeMeta("vmxnet"));
        this.networkCards.put(VmMetaData.EthernetDevType.VMXNET3, new VmWareEthernetDevTypeMeta("vmxnet3"));
    }

    static {
        String[] list = new String[]{"^guestos", "^uuid\\.bios", "^config\\.version", "^ehci\\.", "^mks\\.enable3d", "^virtualhw\\.", "^sound\\.", "\\.pcislotnumber$", "^pcibridge", "\\.virtualdev$", "^tools\\.syncTime$", "^time\\.synchronize", "^bios\\.bootDelay", "^rtc\\.", "^xhci\\."};
        whitelist = new Pattern[list.length];
        for (int i = 0; i < list.length; ++i) {
            VmwareMetaData.whitelist[i] = Pattern.compile(list[i].toLowerCase());
        }
    }

    private static class Controller {
        public boolean present = true;
        public String virtualDev = null;
        Map<String, Device> devices = new HashMap<String, Device>();

        private Controller() {
        }

        public String toString() {
            return this.virtualDev + " is (present: " + this.present + "): " + this.devices.toString();
        }
    }

    private static class Device {
        public boolean present = false;
        public String deviceType = null;
        public String filename = null;

        private Device() {
        }

        public String toString() {
            return this.filename + " is " + this.deviceType + " (present: " + this.present + ")";
        }
    }

    public static enum EthernetType {
        NAT("vmnet1"),
        BRIDGED("vmnet0"),
        HOST_ONLY("vmnet2");

        public final String vmnet;

        private EthernetType(String vnet) {
            this.vmnet = vnet;
        }
    }
}

