/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openslx.bwlp.thrift.iface.TransferInformation;

public abstract class AbstractTransfer {
    private static final long FINISH_TIMEOUT = TimeUnit.MINUTES.toMillis(3L);
    private static final long IDLE_TIMEOUT = TimeUnit.HOURS.toMillis(6L);
    private static final long HOT_IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    protected final AtomicLong potentialFinishTime = new AtomicLong(0L);
    protected final AtomicLong lastActivityTime = new AtomicLong(System.currentTimeMillis());
    private final String transferId;
    protected AtomicInteger connectFails = new AtomicInteger();

    public AbstractTransfer(String transferId) {
        this.transferId = transferId;
    }

    public boolean isComplete(long now) {
        long val = this.potentialFinishTime.get();
        return val != 0L && val + FINISH_TIMEOUT < now;
    }

    public final boolean hasReachedIdleTimeout(long now) {
        return this.getActiveConnectionCount() == 0 && this.lastActivityTime.get() + IDLE_TIMEOUT < now;
    }

    public final boolean countsTowardsConnectionLimit(long now) {
        return this.getActiveConnectionCount() > 0 || this.lastActivityTime.get() + HOT_IDLE_TIMEOUT > now;
    }

    public final int connectFailCount() {
        return this.connectFails.get();
    }

    public final String getId() {
        return this.transferId;
    }

    public abstract TransferInformation getTransferInfo();

    public abstract boolean isActive();

    public abstract void cancel();

    public abstract int getActiveConnectionCount();

    public abstract String getRelativePath();

    static void safeClose(AutoCloseable ... item) {
        if (item == null) {
            return;
        }
        for (AutoCloseable c : item) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

