/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.SessionData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class News {
    private static final Logger LOGGER = Logger.getLogger(News.class);
    private static String headline = null;
    private static String content = null;
    private static Date date = null;

    public static String getHeadline() {
        if (headline != null) {
            return headline;
        }
        News.init();
        if (headline != null) {
            return headline;
        }
        return null;
    }

    public static String getContent() {
        if (content != null) {
            return content;
        }
        News.init();
        if (content != null) {
            return content;
        }
        return null;
    }

    public static Date getDate() {
        if (date != null) {
            return date;
        }
        News.init();
        if (date != null) {
            return date;
        }
        return null;
    }

    private static void init() {
        Document doc = null;
        String satIp = SessionData._Fields.SERVER_ADDRESS.toString();
        if (satIp == null || satIp.isEmpty()) {
            LOGGER.error("No satellite IP adress is set in SessionData, aborting news fetching...");
            return;
        }
        URL url = null;
        try {
            url = new URL("http://" + SessionData._Fields.SERVER_ADDRESS.toString() + "/slx-admin/api.php?do=news");
        }
        catch (MalformedURLException e) {
            LOGGER.error("Malformated URL to News-API, see trace: ", e);
        }
        if (url == null) {
            LOGGER.error("URL to the News-API not defined!");
            return;
        }
        URLConnection urlCon = null;
        try {
            urlCon = url.openConnection();
            urlCon.setConnectTimeout(5000);
            urlCon.setReadTimeout(10000);
        }
        catch (IOException e) {
            LOGGER.error("IO error while requesting News URL, see trace: ", e);
            return;
        }
        InputStream is = null;
        try {
            is = urlCon.getInputStream();
        }
        catch (IOException e1) {
            LOGGER.error("Could not open stream to URL '" + url.toString() + "', see trace: ", e1);
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("XML parsing configuration error, see trace: ", e);
            return;
        }
        try {
            doc = builder.parse(is);
        }
        catch (SAXException e) {
            LOGGER.error("XML parsing error, see trace: ", e);
            return;
        }
        catch (IOException e) {
            LOGGER.error("IO-Error, see trace: ", e);
            return;
        }
        Element docRoot = doc.getDocumentElement();
        if (docRoot.getNodeName().equals("news")) {
            Node headlineNode = null;
            Node contentNode = null;
            Node dateNode = null;
            NodeList nList = docRoot.getElementsByTagName("*");
            if (nList == null) {
                return;
            }
            for (int i = 0; i < nList.getLength(); ++i) {
                Node current = nList.item(i);
                if (current.getNodeType() != 1) continue;
                if (current.getNodeName().equals("headline") && current.getFirstChild().getNodeType() == 3) {
                    headlineNode = current.getFirstChild();
                }
                if ((current.getNodeName().equals("info") || current.getNodeName().equals("content")) && current.getFirstChild().getNodeType() == 3) {
                    contentNode = current.getFirstChild();
                }
                if (!current.getNodeName().equals("date") || current.getFirstChild().getNodeType() != 3) continue;
                dateNode = current.getFirstChild();
            }
            if (headlineNode != null) {
                headline = headlineNode.getNodeValue().trim();
            }
            if (contentNode != null) {
                content = contentNode.getNodeValue().trim();
            }
            if (dateNode != null) {
                Date tmpDate = null;
                try {
                    tmpDate = new Date(Long.parseLong(dateNode.getNodeValue().trim()) * 1000L);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error("Date format is invalid, see trace: ", nfe);
                }
                if (tmpDate != null) {
                    date = tmpDate;
                }
            }
        } else {
            LOGGER.error("No valid news in the response!");
            return;
        }
    }
}

