/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift.cache;

import java.util.List;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvocationException;
import org.openslx.dozmod.thrift.Session;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.GenericDataCache;

public class LectureCache {
    private static final int CACHE_TIME_LIST_MS = 30000;
    private static final GenericDataCache<List<LectureSummary>> listCache = new GenericDataCache<List<LectureSummary>>(30000){

        @Override
        protected List<LectureSummary> update() throws TAuthorizationException, TInvocationException, TException {
            List<LectureSummary> result = null;
            int pageSize = Session.getSatelliteConfig().pageSize;
            int i = 0;
            while (true) {
                List<LectureSummary> page = ThriftManager.getSatClient().getLectureList(Session.getSatelliteToken(), i);
                if (result == null) {
                    result = page;
                } else {
                    result.addAll(page);
                }
                if (page.size() < pageSize) break;
                ++i;
            }
            return result;
        }
    };

    public static List<LectureSummary> get(boolean forceRefresh) {
        return listCache.get(forceRefresh ? GenericDataCache.CacheMode.NEVER_CACHED : GenericDataCache.CacheMode.DEFAULT);
    }
}

