/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.control.table.LectureTable;
import org.openslx.dozmod.gui.control.table.QScrollPane;
import org.openslx.dozmod.gui.helper.CompositePage;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.window.LectureListWindow;

public abstract class LectureListWindowLayout
extends CompositePage {
    private static final int ICON_SIZE_Y = 24;
    private static final String infoTitleString = "\u00dcbersicht Veranstaltungen";
    private static final String newButtonLabel = "Neue Veranstaltung";
    private static final String editButtonLabel = "Bearbeiten";
    private static final String deleteButtonLabel = "L\u00f6schen";
    private static final String switchViewButtonLabel = "VMs zeigen";
    private static final String filterPanelLabel = "Suchen";
    private static final String infoTextString = "Hier k\u00f6nnen Sie Veranstaltungen anlegen, bearbeiten und l\u00f6schen.";
    protected final JButton btnNewLecture;
    protected final JButton btnDeleteLecture;
    protected final JButton btnEditLecture;
    protected final JButton btnSwitchView;
    protected final JComboBox<LectureListWindow.FilterType> cboFilter;
    protected final QLabel lblVisibleLectureCount;
    protected final JTextField txtSearch;
    protected final LectureTable tblLectures;

    public LectureListWindowLayout() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridManager grid = new GridManager(this, 1);
        JPanel infoPanel = new JPanel(new BorderLayout());
        QLabel infoTitle = new QLabel(infoTitleString);
        infoTitle.setFont(infoTitle.getFont().deriveFont(1));
        QLabel infoText = new QLabel(infoTextString);
        infoPanel.add((Component)infoTitle, "North");
        infoPanel.add((Component)infoText, "Center");
        JPanel tablePanel = new JPanel();
        GridManager tableGrid = new GridManager(tablePanel, 1);
        JPanel filterPanel = new JPanel();
        filterPanel.setBorder(new TitledBorder(filterPanelLabel));
        filterPanel.setLayout(new BoxLayout(filterPanel, 2));
        this.txtSearch = new JTextField();
        this.cboFilter = new JComboBox();
        for (LectureListWindow.FilterType s : LectureListWindow.FilterType.values()) {
            this.cboFilter.addItem(s);
        }
        filterPanel.add(this.txtSearch);
        filterPanel.add(this.cboFilter);
        JPanel lectureCountPanel = new JPanel();
        this.lblVisibleLectureCount = new QLabel();
        lectureCountPanel.add(new JLabel("Sichtbar:"));
        lectureCountPanel.add(this.lblVisibleLectureCount);
        filterPanel.add(lectureCountPanel);
        this.tblLectures = new LectureTable();
        tableGrid.add(filterPanel).fill(true, false).expand(true, false);
        tableGrid.nextRow();
        QScrollPane jsp = new QScrollPane(this.tblLectures);
        jsp.setBackground(UIManager.getColor("Table.background"));
        tableGrid.add(jsp).fill(true, true).expand(true, true);
        tableGrid.nextRow();
        tableGrid.finish(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.btnNewLecture = new JButton(newButtonLabel, Gui.getScaledIconResource("/img/new-lecture-icon.png", "New Lecture", 24, buttonPanel));
        this.btnEditLecture = new JButton(editButtonLabel, Gui.getScaledIconResource("/img/edit-icon.png", "Edit Lecture", 24, buttonPanel));
        this.btnDeleteLecture = new JButton(deleteButtonLabel, Gui.getScaledIconResource("/img/delete-icon.png", "Delete Lecture", 24, buttonPanel));
        this.btnSwitchView = new JButton(switchViewButtonLabel, Gui.getScaledIconResource("/img/switch-icon.png", "Switch", 24, buttonPanel));
        buttonPanel.add(this.btnNewLecture);
        buttonPanel.add(this.btnEditLecture);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this.btnDeleteLecture);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.btnSwitchView);
        grid.add(infoPanel).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(tablePanel).fill(true, true).expand(true, true);
        grid.nextRow();
        grid.add(buttonPanel).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.finish(false);
    }

    protected void setLectureCountLabel(int i) {
        this.lblVisibleLectureCount.setText(Integer.toString(i));
    }
}

