/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.UIManager;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.control.WordWrapLabel;
import org.openslx.dozmod.gui.helper.GridManager;

public class ConfigWindowLayout
extends JDialog {
    private static String title = Branding.getApplicationName() + " - Konfiguration";
    protected final JRadioButton btnProxyNone;
    protected final JRadioButton btnProxyAuto;
    protected final JRadioButton btnProxySocks = null;
    protected final JRadioButton btnProxyHttp = null;
    protected final JCheckBox chkSendMeMail;
    protected final QLabel lblYourAddress;
    protected final JSlider sldFontSize;
    protected final JSlider sldConnections;
    protected ButtonGroup btnGroupLookAndFeel = null;
    protected final JButton btnSave;
    protected final JButton btnClose;

    public ConfigWindowLayout(Window modalParent) {
        super(modalParent, title, modalParent != null ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.getContentPane().setLayout(new BorderLayout());
        Insets headingInset = new Insets(16, 12, 3, 3);
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        GridManager grid = new GridManager(contentPanel, 1, false, new Insets(4, 3, 1, 3));
        grid.add(new WordWrapLabel("E-Mail-Benachrichtigungen", true, false)).insets(headingInset).expand(true, false).fill(true, false);
        this.chkSendMeMail = new JCheckBox("\u00dcber VM- und Veranstaltungs\u00e4nderungen per E-Mail informiert werden");
        grid.add(this.chkSendMeMail).fill(true, false).expand(true, false);
        grid.add(new WordWrapLabel("F\u00fcr diese Option muss der Server f\u00fcr den Mailversand konfiguriert sein.", false, true)).expand(true, false).fill(true, false);
        this.lblYourAddress = new QLabel();
        grid.add(this.lblYourAddress).fill(true, false).expand(true, false);
        grid.add(new WordWrapLabel("Proxyserver", true, false)).insets(headingInset).fill(true, false).expand(true, false);
        JPanel radioGroupPanel = new JPanel();
        radioGroupPanel.setLayout(new BoxLayout(radioGroupPanel, 2));
        ButtonGroup radioGroup = new ButtonGroup();
        this.btnProxyNone = new JRadioButton("Keinen Proxy verwenden");
        this.btnProxyAuto = new JRadioButton("Automatisch nach Proxy suchen");
        radioGroup.add(this.btnProxyNone);
        radioGroup.add(this.btnProxyAuto);
        radioGroupPanel.add(this.btnProxyNone);
        radioGroupPanel.add(this.btnProxyAuto);
        grid.add(radioGroupPanel).expand(true, false).fill(true, false);
        grid.add(new WordWrapLabel("Schriftgr\u00f6\u00dfe (%)", true, false)).insets(headingInset).fill(true, false).expand(true, false);
        grid.add(new WordWrapLabel("Diese Funktion ist experimentell. Es kann zu Anzeigefehlern kommen.", false, true)).expand(true, false).fill(true, false);
        UIManager.put("Slider.paintValue", false);
        this.sldFontSize = new JSlider(0);
        this.sldFontSize.setModel(new DefaultBoundedRangeModel(100, 0, 75, 175));
        this.sldFontSize.setMinorTickSpacing(5);
        this.sldFontSize.setMajorTickSpacing(25);
        this.sldFontSize.setSnapToTicks(true);
        this.sldFontSize.setPaintTicks(true);
        this.sldFontSize.setPaintLabels(true);
        grid.add(this.sldFontSize).fill(true, false).expand(true, false);
        grid.add(new WordWrapLabel("LookAndFeel", true, false)).insets(headingInset).fill(true, false).expand(true, false);
        grid.add(new WordWrapLabel("Hier k\u00f6nnen Sie die Darstellung der Oberfl\u00e4che zwischen unterschiedlichen 'LookAndFeels' umstellen.", false, true)).fill(true, false).expand(true, false);
        JPanel lafGroupPanel = new JPanel();
        lafGroupPanel.setLayout(new BoxLayout(lafGroupPanel, 2));
        this.btnGroupLookAndFeel = new ButtonGroup();
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            JRadioButton btn = new JRadioButton(laf.getName());
            btn.setToolTipText(laf.getClassName());
            this.btnGroupLookAndFeel.add(btn);
            lafGroupPanel.add(btn);
        }
        grid.add(lafGroupPanel).expand(true, false).fill(true, false);
        grid.add(new WordWrapLabel("Verbindungen pro Transfer", true, false)).insets(headingInset).fill(true, false).expand(true, false);
        grid.add(new WordWrapLabel("Im Normalfall werden beste Ergebnisse erzielt, wenn die Einstellung auf 1 belassen wird. Falls die \u00dcbertragungsgeschwindigkeit ihre Netzwerkanbindung nicht auslastet, probieren Sie den n\u00e4chsth\u00f6heren Wert. Zu hohe Werte k\u00f6nnen einen negativen Effekt auf die \u00dcbertragungsgeschwindigkeit haben, und belasten den Satellitenserver st\u00e4rker.", false, true)).fill(true, false).expand(true, false);
        this.sldConnections = new JSlider(0);
        this.sldConnections.setModel(new DefaultBoundedRangeModel(1, 0, 1, 4));
        this.sldConnections.setMajorTickSpacing(1);
        this.sldConnections.setPaintTicks(true);
        this.sldConnections.setPaintLabels(true);
        grid.add(this.sldConnections).expand(true, false).fill(true, false);
        grid.finish(true);
        JPanel buttonPanel = new JPanel();
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnSave = new JButton("Speichern");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.btnClose);
        buttonPanel.add(this.btnSave);
        this.getContentPane().add((Component)buttonPanel, "Last");
        this.setPreferredSize(Gui.getScaledDimension(500, 650));
    }
}

