/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.apache.log4j.Logger;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.layout.VirtualizerNoticeWindowLayout;
import org.openslx.dozmod.util.DesktopEnvironment;

public class VirtualizerNoticeWindow
extends VirtualizerNoticeWindowLayout
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(VirtualizerNoticeWindow.class);

    public VirtualizerNoticeWindow(Frame modalParent) {
        super(modalParent);
        final VirtualizerNoticeWindow me = this;
        this.setDefaultCloseOperation(2);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.setVirtualizerRead(true);
                me.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Config.setVirtualizerRead(true);
            }
        });
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopEnvironment.openWebpage(DesktopEnvironment.Link.VMWARE);
            }
        });
    }

    public static void open(Frame modalParent) {
        new VirtualizerNoticeWindow(modalParent).setVisible(true);
    }

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    @Override
    public void escapePressed() {
        this.dispose();
    }
}

