/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JRadioButton;
import org.openslx.bwlp.thrift.iface.Satellite;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.layout.SatelliteListWindowLayout;

public class SatelliteListWindow
extends SatelliteListWindowLayout
implements UiFeedback {
    private Satellite satellite = null;

    private SatelliteListWindow(Window modalParent, List<Satellite> satList) {
        super(modalParent, satList);
        MouseAdapter radioDoubleClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    if (e.getSource() instanceof JRadioButton) {
                        ((JRadioButton)e.getSource()).setSelected(true);
                    }
                    SatelliteListWindow.this.prepareSelection();
                    if (SatelliteListWindow.this.satellite != null) {
                        SatelliteListWindow.this.dispose();
                    }
                }
            }
        };
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SatelliteListWindow.this.txtCustomAddress.setEnabled(SatelliteListWindow.this.rdoCusomAddress.isSelected());
            }
        };
        for (JRadioButton radio : this.radioToSat.keySet()) {
            radio.addActionListener(listener);
        }
        this.rdoCusomAddress.addActionListener(listener);
        String lastSat = Config.getLastSatellite();
        if (satList != null && !satList.isEmpty()) {
            for (Map.Entry entry : this.radioToSat.entrySet()) {
                if (!lastSat.isEmpty()) {
                    Satellite sat = (Satellite)entry.getValue();
                    if (sat.displayName.equals(lastSat)) {
                        ((JRadioButton)entry.getKey()).setSelected(true);
                        ((JRadioButton)entry.getKey()).requestFocus();
                        this.txtCustomAddress.setEnabled(false);
                        lastSat = "";
                    }
                }
                ((JRadioButton)entry.getKey()).addMouseListener(radioDoubleClick);
            }
        } else {
            this.rdoCusomAddress.setSelected(true);
            this.txtCustomAddress.requestFocus();
        }
        if (lastSat.startsWith("@")) {
            this.txtCustomAddress.setText(lastSat.substring(1));
            this.rdoCusomAddress.setSelected(true);
            this.txtCustomAddress.requestFocus();
        }
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SatelliteListWindow.this.dispose();
            }
        });
        this.btnContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SatelliteListWindow.this.prepareSelection();
                if (SatelliteListWindow.this.satellite != null) {
                    if (SatelliteListWindow.this.rdoCusomAddress.isSelected()) {
                        Config.setLastSatellite("@" + SatelliteListWindow.this.txtCustomAddress.getText());
                    } else if (((SatelliteListWindow)SatelliteListWindow.this).satellite.displayName != null && !((SatelliteListWindow)SatelliteListWindow.this).satellite.displayName.isEmpty()) {
                        Config.setLastSatellite(((SatelliteListWindow)SatelliteListWindow.this).satellite.displayName);
                    }
                    SatelliteListWindow.this.dispose();
                } else {
                    Gui.showMessageBox(SatelliteListWindow.this.rootPane, "Kein Satellit ausgew\u00e4hlt", MessageType.ERROR, null, null);
                }
            }
        });
        this.getRootPane().setDefaultButton(this.btnContinue);
        Gui.centerShellOverShell(modalParent, this);
    }

    private void prepareSelection() {
        if (!this.rdoCusomAddress.isSelected()) {
            for (Map.Entry entry : this.radioToSat.entrySet()) {
                if (!((JRadioButton)entry.getKey()).isSelected()) continue;
                this.satellite = (Satellite)entry.getValue();
                break;
            }
        }
        if (this.rdoCusomAddress.isSelected() && !this.txtCustomAddress.getText().isEmpty()) {
            this.satellite = new Satellite();
            this.satellite.addressList = new ArrayList<String>();
            this.satellite.addressList.add(this.txtCustomAddress.getText());
        }
    }

    private Satellite runAndReturn() {
        this.setVisible(true);
        return this.satellite;
    }

    public static Satellite open(final Window modalParent, final List<Satellite> satList) {
        return Gui.syncExec(new Gui.GuiCallable<Satellite>(){

            @Override
            public Satellite run() {
                return new SatelliteListWindow(modalParent, satList).runAndReturn();
            }
        });
    }

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    @Override
    public void escapePressed() {
        this.dispose();
    }

    public static interface UserAddedCallback {
        public void userAdded(UserInfo var1, SatelliteListWindow var2);
    }
}

