/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.DefaultRowSorter;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.control.table.ImageTable;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.gui.control.table.QScrollPane;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.permissions.ImagePerms;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.cache.ImageCache;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.util.QuickTimer;

public class ImageListViewer
extends QLabel {
    private static final Logger LOGGER = Logger.getLogger(ImageListViewer.class);
    protected JTextField txtSearch;
    protected JComboBox<FilterType> cboFilter;
    protected JLabel imageCountLabel;
    protected ImageTable imageTable;
    private final RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer> filterOwn = new RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends ListTable.ListModel<ImageSummaryRead>, ? extends Integer> entry) {
            ImageSummaryRead img = (ImageSummaryRead)ImageListViewer.this.imageTable.getModelRow(entry.getIdentifier());
            return ImagePerms.canAdmin(img) || img.ownerId.equals(Session.getUserId());
        }
    };
    private final RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer> filterUsable = new RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends ListTable.ListModel<ImageSummaryRead>, ? extends Integer> entry) {
            ImageSummaryRead img = (ImageSummaryRead)ImageListViewer.this.imageTable.getModelRow(entry.getIdentifier());
            return ImagePerms.canLink(img) && img.isValid;
        }
    };
    private final RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer> filterEditable = new RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends ListTable.ListModel<ImageSummaryRead>, ? extends Integer> entry) {
            return ImagePerms.canEdit((ImageSummaryRead)ImageListViewer.this.imageTable.getModelRow(entry.getIdentifier()));
        }
    };
    private final RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer> filterTemplate = new RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends ListTable.ListModel<ImageSummaryRead>, ? extends Integer> entry) {
            return ((ImageSummaryRead)ImageListViewer.this.imageTable.getModelRow((int)entry.getIdentifier().intValue())).isTemplate;
        }
    };
    private Pattern searchFieldPattern = null;
    private final RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer> filterSearchTerm = new RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends ListTable.ListModel<ImageSummaryRead>, ? extends Integer> entry) {
            ImageSummaryRead image = (ImageSummaryRead)ImageListViewer.this.imageTable.getModelRow(entry.getIdentifier());
            if (ImageListViewer.this.searchFieldPattern.matcher(image.imageName).find()) {
                return true;
            }
            UserInfo user = UserCache.find(image.ownerId);
            if (user == null) {
                return false;
            }
            if (ImageListViewer.this.searchFieldPattern.matcher(user.firstName).find()) {
                return true;
            }
            if (ImageListViewer.this.searchFieldPattern.matcher(user.lastName).find()) {
                return true;
            }
            return ImageListViewer.this.searchFieldPattern.matcher(user.eMail).find();
        }
    };

    public ImageListViewer(FilterType defaultFilter) {
        GridManager grid = new GridManager(this, 1);
        JPanel filterPanel = new JPanel();
        filterPanel.setBorder(new TitledBorder("Suchen"));
        filterPanel.setLayout(new BoxLayout(filterPanel, 2));
        this.txtSearch = new JTextField();
        this.cboFilter = new JComboBox();
        for (FilterType s : FilterType.values()) {
            this.cboFilter.addItem(s);
        }
        filterPanel.add(this.txtSearch);
        filterPanel.add(this.cboFilter);
        JPanel imageCountPanel = new JPanel();
        this.imageCountLabel = new JLabel();
        imageCountPanel.add(new JLabel("Sichtbar:"));
        imageCountPanel.add(this.imageCountLabel);
        filterPanel.add(imageCountPanel);
        grid.add(filterPanel).fill(true, false).expand(true, false);
        grid.nextRow();
        this.imageTable = new ImageTable();
        QScrollPane jsp = new QScrollPane(this.imageTable);
        jsp.setBackground(UIManager.getColor("Table.background"));
        grid.add(jsp).fill(true, true).expand(true, true);
        grid.finish(false);
        this.txtSearch.getDocument().addDocumentListener(new TextChangeListener(){

            @Override
            public void changed() {
                String str = ImageListViewer.this.txtSearch.getText();
                if (str == null || str.isEmpty()) {
                    ImageListViewer.this.searchFieldPattern = null;
                } else {
                    try {
                        ImageListViewer.this.searchFieldPattern = Pattern.compile(str, 2);
                        ImageListViewer.this.txtSearch.setForeground(UIManager.getColor("TextField.foreground"));
                    }
                    catch (PatternSyntaxException ex) {
                        ImageListViewer.this.txtSearch.setForeground(Color.RED);
                    }
                }
                ImageListViewer.this.applyFilterOnTable();
            }
        });
        this.cboFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageListViewer.this.applyFilterOnTable();
            }
        });
        this.cboFilter.setSelectedItem((Object)(defaultFilter == null ? FilterType.USABLE : defaultFilter));
    }

    private void applyFilterOnTable() {
        ArrayList<RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>> filters = new ArrayList<RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>>();
        if (this.searchFieldPattern != null) {
            filters.add(this.filterSearchTerm);
        }
        FilterType filterType = (FilterType)((Object)this.cboFilter.getSelectedItem());
        switch (filterType) {
            case ALL: {
                break;
            }
            case OWN: {
                filters.add(this.filterOwn);
                break;
            }
            case USABLE: {
                filters.add(this.filterUsable);
                break;
            }
            case EDITABLE: {
                filters.add(this.filterEditable);
                break;
            }
            case TEMPLATES: {
                filters.add(this.filterTemplate);
            }
        }
        RowFilter andFilters = RowFilter.andFilter(filters);
        ((DefaultRowSorter)this.imageTable.getRowSorter()).setRowFilter(andFilters);
        this.setImageCountLabel(this.imageTable.getRowCount());
    }

    public void refreshList(final boolean forceRefresh, int delay) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                final List<ImageSummaryRead> imageList = ImageCache.get(forceRefresh);
                String virtId = null;
                boolean m = false;
                for (ImageSummaryRead isr : imageList) {
                    if (virtId == null) {
                        virtId = isr.virtId;
                        continue;
                    }
                    if (virtId.equals(isr.virtId)) continue;
                    m = true;
                    break;
                }
                final boolean showVirt = m;
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageListViewer.this.imageTable.setData(imageList, true);
                        ImageListViewer.this.imageTable.setColumnVisible(ImageTable.COL_HYPERVISOR, showVirt);
                        ImageListViewer.this.setImageCountLabel(ImageListViewer.this.imageTable.getRowCount());
                    }
                });
            }
        }, delay);
    }

    public ImageTable getImageTable() {
        return this.imageTable;
    }

    protected void setImageCountLabel(int i) {
        this.imageCountLabel.setText(Integer.toString(i));
    }

    public static enum FilterType {
        ALL("Alle anzeigen"),
        OWN("Nur eigene/zugewiesene anzeigen"),
        USABLE("Nur verwendbare/linkbare anzeigen"),
        EDITABLE("Nur editierbare anzeigen"),
        TEMPLATES("Nur Vorlagen zeigen");

        private final String name;

        private FilterType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

