/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.configurator;

import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.LectureRead;
import org.openslx.bwlp.thrift.iface.PresetRunScript;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;
import org.openslx.dozmod.gui.configurator.RunscriptType;
import org.openslx.dozmod.gui.configurator.RunscriptVisibility;
import org.openslx.dozmod.gui.configurator.SoundState;
import org.openslx.dozmod.gui.configurator.StartupConfiguratorLayout;
import org.openslx.dozmod.gui.control.WordWrapLabel;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class StartupConfigurator
extends StartupConfiguratorLayout {
    private static final long serialVersionUID = -3497629601818983994L;
    private StartupSettings startupSettings = new StartupSettings(null);
    private ImageDetailsRead image;
    private List<PresetRunScript> scripts;
    private LectureRead lecture;
    protected final JTextField fakeTextField = new JTextField();

    public StartupConfigurator() {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                StartupConfigurator.this.scripts = MetaDataCache.getPredefinedRunScripts();
                if (StartupConfigurator.this.scripts.isEmpty()) {
                    Gui.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            StartupConfigurator.this.btnPredefinedScripts.setVisible(false);
                        }
                    });
                }
            }
        });
        this.btnPredefinedScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartupConfigurator.this.showRunscriptSelector();
            }
        });
    }

    private void showRunscriptSelector() {
        if (this.scripts == null) {
            Gui.showMessageBox("Wah wah wah! Null scripts", MessageType.ERROR, null, null);
            return;
        }
        final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(this), "Startscripte ausw\u00e4hlen", Dialog.ModalityType.APPLICATION_MODAL);
        JPanel pane = new JPanel();
        dialog.setContentPane(pane);
        dialog.setMinimumSize(Gui.getScaledDimension(200, 300));
        GridManager grid = new GridManager(pane, 2, true, new Insets(2, 2, 2, 2));
        final HashMap<ButtonModel, Integer> mapper = new HashMap<ButtonModel, Integer>();
        boolean haveDisabled = false;
        for (PresetRunScript ruleSet : this.scripts) {
            JCheckBox button = new JCheckBox(ruleSet.displayname);
            grid.add(button, 2);
            grid.nextRow();
            mapper.put(button.getModel(), ruleSet.scriptId);
            if (this.image != null && ruleSet.osIds != null && !ruleSet.osIds.contains(this.image.osId)) {
                button.setEnabled(false);
                haveDisabled = true;
            }
            if (this.lecture == null || this.lecture.presetScriptIds == null || !this.lecture.presetScriptIds.contains(ruleSet.scriptId)) continue;
            button.setSelected(true);
        }
        if (haveDisabled) {
            grid.add(new WordWrapLabel("Ausgegraute Elemente sind mit dem zur Veranstaltung geh\u00f6rendem Betriebssystem nicht kompatibel"), 2);
            grid.nextRow();
        }
        JButton btnCancel = new JButton("Abbrechen");
        JButton btnOk = new JButton("SPASCHAN");
        grid.add(btnCancel).anchor(21);
        grid.add(btnOk).anchor(22);
        grid.finish(true);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        final AtomicReference selectedScripts = new AtomicReference();
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList selected = new ArrayList();
                for (Map.Entry button : mapper.entrySet()) {
                    if (!((ButtonModel)button.getKey()).isSelected()) continue;
                    selected.add(button.getValue());
                }
                selectedScripts.set(selected);
                dialog.dispose();
            }
        });
        dialog.pack();
        Gui.centerShellOverShell(SwingUtilities.getWindowAncestor(this), dialog);
        dialog.setVisible(true);
        if (selectedScripts.get() != null) {
            this.lecture.presetScriptIds = this.startupSettings.selectedScripts = (List)selectedScripts.get();
            this.fakeTextField.setText(this.startupSettings.selectedScripts.toString());
        }
    }

    private void setError(String msg) {
        this.lblError.setText(msg);
    }

    public StartupSettings getState() {
        this.setError("");
        Object cboContent = this.cboRunscriptType.getEditor().getItem();
        if (cboContent instanceof RunscriptType) {
            this.startupSettings.put(Field.EXTENSION, ((RunscriptType)((Object)cboContent)).extension);
        } else if (cboContent instanceof String) {
            this.startupSettings.put(Field.EXTENSION, (String)cboContent);
        }
        this.startupSettings.runScript = this.taRunScript.getText();
        RunscriptVisibility visibility = (RunscriptVisibility)((Object)this.cboRunscriptVisibility.getSelectedItem());
        this.startupSettings.put(Field.VISIBILITY, Integer.toString(visibility.value));
        SoundState sound = (SoundState)((Object)this.cboSoundState.getSelectedItem());
        this.startupSettings.put(Field.MUTED, Integer.toString(sound.value));
        this.setError("");
        return this.startupSettings;
    }

    public void setState(final LectureRead lecture) {
        if (lecture == null) {
            return;
        }
        this.lecture = lecture;
        this.setCustomScript(lecture.runscript);
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                try {
                    StartupConfigurator.this.image = ThriftManager.getSatClient().getImageDetails(Session.getSatelliteToken(), lecture.imageBaseId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (lecture.presetScriptIds != null) {
            this.fakeTextField.setText(lecture.presetScriptIds.toString());
        }
    }

    private void setCustomScript(String lecture) {
        if (lecture == null || lecture.isEmpty()) {
            this.cboRunscriptType.setSelectedItem(null);
            this.taRunScript.setText("");
            return;
        }
        this.startupSettings.deserializeItems(lecture);
        String extension = this.startupSettings.get(Field.EXTENSION);
        for (RunscriptType type : RunscriptType.values()) {
            if (!type.extension.equals(extension)) continue;
            this.cboRunscriptType.setSelectedItem((Object)type);
            extension = null;
            break;
        }
        int visibility = Util.parseInt(this.startupSettings.get(Field.VISIBILITY), 1);
        for (RunscriptVisibility windowFlag : RunscriptVisibility.values()) {
            if (windowFlag.value != visibility) continue;
            this.cboRunscriptVisibility.setSelectedItem((Object)windowFlag);
            break;
        }
        this.cboSoundState.setSelectedItem((Object)SoundState.DEFAULT);
        int mute = Util.parseInt(this.startupSettings.get(Field.MUTED), -1);
        for (SoundState s : SoundState.values()) {
            if (s.value != mute) continue;
            this.cboSoundState.setSelectedItem((Object)s);
            break;
        }
        if (extension != null) {
            this.cboRunscriptType.getEditor().setItem(extension);
        }
        this.taRunScript.setText(this.startupSettings.runScript);
    }

    public void addToChangeMonitor(DialogChangeMonitor changeMonitor) {
        changeMonitor.add(this.taRunScript);
        changeMonitor.addEditableCombo(this.cboRunscriptType, null);
        changeMonitor.addFixedCombo(this.cboRunscriptVisibility, null);
        changeMonitor.addFixedCombo(this.cboSoundState, null);
        changeMonitor.add(this.fakeTextField);
    }

    public static class StartupSettings {
        public Map<String, String> items = new HashMap<String, String>();
        public String runScript;
        public List<Integer> selectedScripts;

        public StartupSettings(String data) {
            this.deserializeItems(data);
        }

        public String put(Field key, String value) {
            value = value.replace(';', '_').replace('\r', '_').replace('\n', '_');
            return this.items.put(key.id, value);
        }

        public String get(Field key) {
            String ret = this.items.get(key.id);
            if (ret == null) {
                return "";
            }
            return ret;
        }

        public String serializeItems() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> e : this.items.entrySet()) {
                if (sb.length() != 0) {
                    sb.append(';');
                }
                sb.append(e.getKey());
                sb.append('=');
                sb.append(e.getValue());
            }
            sb.append('\n');
            if (this.runScript != null) {
                sb.append(this.runScript);
            }
            return sb.toString();
        }

        public void deserializeItems(String data) {
            String[] parts;
            if (data == null || data.isEmpty()) {
                return;
            }
            String[] stuff = data.split("\n", 2);
            this.items.clear();
            for (String s : parts = stuff[0].split(";")) {
                String[] entry = s.split("=");
                if (entry.length != 2) continue;
                this.items.put(entry[0], entry[1]);
            }
            this.runScript = stuff.length < 2 ? "" : stuff[1];
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StartupSettings)) {
                return false;
            }
            StartupSettings other = (StartupSettings)obj;
            if (this.selectedScripts == other.selectedScripts) {
                return true;
            }
            if (this.selectedScripts == null) {
                return false;
            }
            return this.selectedScripts.equals(other.selectedScripts);
        }
    }

    private static enum Field {
        EXTENSION("ext"),
        VISIBILITY("visibility"),
        MUTED("soundMuted");

        public final String id;

        private Field(String id) {
            this.id = id;
        }
    }
}

