/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.configurator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.LdapFilter;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;
import org.openslx.dozmod.gui.configurator.LdapFilterConfiguratorLayout;
import org.openslx.dozmod.gui.control.table.CheckListTable;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.thrift.cache.MetaDataCache;

public class LdapFilterConfigurator
extends LdapFilterConfiguratorLayout {
    private static final long serialVersionUID = -3336605759245603655L;
    private static final Logger LOGGER = Logger.getLogger(LdapFilterConfigurator.class);
    protected List<ChangeListener> listenerList = new ArrayList<ChangeListener>();

    public LdapFilterConfigurator() {
        ((AbstractTableModel)this.tblFilters.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                LdapFilterConfigurator.this.fireChangeEvent();
            }
        });
        this.tblFilters.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LdapFilter item = (LdapFilter)LdapFilterConfigurator.this.tblFilters.getSelectedItem2();
                boolean editable = item == null || item.filterId == 0;
                LdapFilterConfigurator.this.txtAttribute.setEditable(editable);
                LdapFilterConfigurator.this.txtValue.setEditable(editable);
                LdapFilterConfigurator.this.btnAdd.setEnabled(editable);
                LdapFilterConfigurator.this.btnDel.setEnabled(editable);
                LdapFilterConfigurator.this.btnAdd.setText("\u00c4ndern");
                if (item == null) {
                    LdapFilterConfigurator.this.clearInputFields();
                    return;
                }
                LdapFilterConfigurator.this.txtAttribute.setText(item.attribute);
                LdapFilterConfigurator.this.txtValue.setText(item.value);
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LdapFilter input = new LdapFilter();
                input.attribute = LdapFilterConfigurator.this.txtAttribute.getText();
                if (input.attribute == null || input.attribute.isEmpty()) {
                    Gui.showMessageBox("Kein Attribut angegeben", MessageType.ERROR, null, null);
                    return;
                }
                input.value = LdapFilterConfigurator.this.txtValue.getText();
                if (input.value == null) {
                    input.value = "";
                }
                CheckListTable.Wrapper<LdapFilter> newEntry = new CheckListTable.Wrapper<LdapFilter>(input, false);
                ArrayList oldList = new ArrayList(LdapFilterConfigurator.this.tblFilters.getData());
                if (oldList.contains(newEntry)) {
                    Gui.showMessageBox("Eintrag bereits vorhanden", MessageType.ERROR, null, null);
                    return;
                }
                CheckListTable.Wrapper oldEntry = (CheckListTable.Wrapper)LdapFilterConfigurator.this.tblFilters.getSelectedItem();
                if (oldEntry != null && oldList.contains(oldEntry)) {
                    oldList.remove(oldEntry);
                }
                oldList.add(newEntry);
                LdapFilterConfigurator.this.tblFilters.setData(oldList, false);
                LdapFilterConfigurator.this.clearInputFields();
            }
        });
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckListTable.Wrapper selection = (CheckListTable.Wrapper)LdapFilterConfigurator.this.tblFilters.getSelectedItem();
                if (selection == null) {
                    return;
                }
                try {
                    ArrayList oldList = new ArrayList(LdapFilterConfigurator.this.tblFilters.getData());
                    if (!oldList.remove(selection)) {
                        LOGGER.error("Could not remove non-existent filter '" + selection.toString() + "' from the table data: " + ((Object)oldList).toString());
                        return;
                    }
                    LdapFilterConfigurator.this.tblFilters.setData(oldList, false);
                }
                catch (Exception ex) {
                    LOGGER.debug("Failed to remove " + selection.toString() + " from the table data.", ex);
                    return;
                }
            }
        });
        this.clearInputFields();
    }

    private void clearInputFields() {
        this.btnDel.setEnabled(false);
        this.txtAttribute.setText(null);
        this.txtValue.setText(null);
        this.btnAdd.setText("Hinzuf\u00fcgen");
    }

    public List<LdapFilter> getState() {
        List current = this.tblFilters.getData();
        if (current == null) {
            return new ArrayList<LdapFilter>(0);
        }
        ArrayList<LdapFilter> ret = new ArrayList<LdapFilter>(current.size());
        for (CheckListTable.Wrapper item : current) {
            if (!item.isChecked() && ((LdapFilter)item.item).filterId != 0) continue;
            ret.add((LdapFilter)item.item);
        }
        return ret;
    }

    public boolean setState(List<LdapFilter> data, List<Integer> predefSelected) {
        if (data == null) {
            return false;
        }
        ArrayList<LdapFilter> filterList = new ArrayList<LdapFilter>(data);
        HashSet<LdapFilter> checked = new HashSet<LdapFilter>();
        List<LdapFilter> predef = MetaDataCache.getPredefinedLdapFilters();
        for (LdapFilter pd : predef) {
            filterList.add(pd);
            if (predefSelected == null || !predefSelected.contains(pd.filterId)) continue;
            checked.add(pd);
        }
        this.tblFilters.setData(filterList, checked, false);
        return true;
    }

    public void addLdapFilterListTableContentConfigurationChangeEventListener(ChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeNetshareConfigurationChangeEventListener(ChangeListener listener) {
        this.listenerList.remove(listener);
    }

    void fireChangeEvent() {
        for (ChangeListener listener : new ArrayList<ChangeListener>(this.listenerList)) {
            listener.stateChanged(null);
        }
    }

    public void addToChangeMonitor(DialogChangeMonitor changeMonitor) {
        changeMonitor.add(this.tblFilters);
    }
}

