/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.activity;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.dozmod.filetransfer.DownloadTask;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.activity.TransferPanel;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.util.DesktopEnvironment;

public class DownloadPanel
extends TransferPanel
implements ActionListener {
    private final DownloadPanel panel = this;
    private final DownloadTask download;
    private final JButton btnOpenFolder = new JButton("Ordner \u00f6ffnen");

    public DownloadPanel(String displayName, String diskFile, DownloadTask download) {
        super(download, displayName, diskFile);
        this.btnOpenFolder.setEnabled(false);
        this.header.add((Component)this.btnOpenFolder, 6);
        this.btnOpenFolder.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.download = download;
        download.addListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnClose) {
            if (!this.download.isCanceled()) {
                if (!Gui.showMessageBox(this.panel, "Wollen Sie diesen Transfer wirklich abbrechen?", MessageType.QUESTION_YESNO, null, null)) {
                    return;
                }
                this.download.cancel();
            }
            this.download.removeListener(this.panel);
            this.close();
        } else if (e.getSource() == this.btnOpenFolder) {
            DesktopEnvironment.openLocal(this.download.getFile().getAbsoluteFile().getParentFile());
        }
    }

    @Override
    public void update(TransferEvent event) {
        super.update(event);
        if (event.state == TransferState.FINISHED) {
            this.btnOpenFolder.setEnabled(true);
        }
    }
}

