/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.scc.dei.ecplean;

import edu.kit.scc.dei.ecplean.ECPAuthenticationException;
import edu.kit.scc.dei.ecplean.ECPAuthenticationInfo;
import edu.kit.scc.dei.ecplean.NamespaceResolver;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Observable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ECPAuthenticatorBase
extends Observable {
    protected static Log logger = LogFactory.getLog(ECPAuthenticatorBase.class);
    protected ECPAuthenticationInfo authInfo;
    protected CloseableHttpClient client;
    protected DocumentBuilderFactory documentBuilderFactory;
    protected XPathFactory xpathFactory;
    protected NamespaceResolver namespaceResolver;
    protected TransformerFactory transformerFactory;

    public ECPAuthenticatorBase(CloseableHttpClient client) {
        this.client = client == null ? HttpClients.createSystem() : client;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.xpathFactory = XPathFactory.newInstance();
        this.namespaceResolver = new NamespaceResolver();
        this.namespaceResolver.addNamespace("ecp", "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
        this.namespaceResolver.addNamespace("S", "http://schemas.xmlsoap.org/soap/envelope/");
        this.namespaceResolver.addNamespace("paos", "urn:liberty:paos:2003-08");
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public ECPAuthenticatorBase() {
        this(null);
    }

    protected Document authenticateIdP(Document idpRequest) throws ECPAuthenticationException {
        String responseBody;
        CloseableHttpResponse httpResponse;
        logger.info("Sending initial IdP Request");
        BasicCredentialsProvider bcp = new BasicCredentialsProvider();
        bcp.setCredentials(new AuthScope(this.authInfo.getIdpEcpEndpoint().getHost(), this.authInfo.getIdpEcpEndpoint().getPort()), new UsernamePasswordCredentials(this.authInfo.getUsername(), this.authInfo.getPassword()));
        HttpClientContext passwordContext = HttpClientContext.create();
        passwordContext.setCredentialsProvider(bcp);
        HttpPost httpPost = new HttpPost(this.authInfo.getIdpEcpEndpoint().toString());
        try {
            httpPost.setEntity(new StringEntity(this.documentToString(idpRequest)));
            httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
            httpResponse = this.client.execute((HttpUriRequest)httpPost, passwordContext);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new ECPAuthenticationException("User not authorized");
            }
        }
        catch (Exception e) {
            httpPost.reset();
            logger.debug("Could not submit PAOS request to IdP");
            throw new ECPAuthenticationException(e);
        }
        try {
            responseBody = EntityUtils.toString(httpResponse.getEntity());
        }
        catch (IOException | RuntimeException e) {
            logger.debug("Could not read response from IdP");
            throw new ECPAuthenticationException(e);
        }
        try {
            httpPost.reset();
            return this.buildDocumentFromString(responseBody);
        }
        catch (IOException | RuntimeException | ParserConfigurationException | SAXException e) {
            logger.debug("Could not parse XML response from IdP:\n" + responseBody);
            throw new ECPAuthenticationException(e);
        }
    }

    protected Document buildDocumentFromString(String input) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        return builder.parse(new InputSource(new StringReader(input)));
    }

    protected Object queryDocument(Document xmlDocument, String expression, QName returnType) throws XPathException {
        XPath xpath = this.xpathFactory.newXPath();
        xpath.setNamespaceContext(this.namespaceResolver);
        XPathExpression xPathExpression = xpath.compile(expression);
        return xPathExpression.evaluate(xmlDocument, returnType);
    }

    protected String documentToString(Document xmlDocument) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(xmlDocument);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public CloseableHttpClient getHttpClient() {
        return this.client;
    }
}

