/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.util;

import com.btr.proxy.selector.fixed.FixedProxySelector;
import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.selector.pac.UrlPacScriptSource;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.MiscUtil;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ProxyUtil {
    public static final int DEFAULT_HTTP_PROXY_PORT = 80;
    public static final int DEFAULT_SOCKS_PROXY_PORT = 1080;
    private static List<Proxy> noProxyList;

    public static FixedProxySelector parseProxySettings(String proxyVar) {
        return ProxyUtil.parseProxySettings(proxyVar, Proxy.Type.HTTP, 0);
    }

    public static FixedProxySelector parseProxySettings(String proxyVar, Proxy.Type fallback, int fallbackPort) {
        Proxy proxy = ProxyUtil.parseProxyString(proxyVar, fallback, fallbackPort);
        if (proxy == null) {
            return null;
        }
        return new FixedProxySelector(proxy);
    }

    public static Proxy parseProxyString(String proxyVar, Proxy.Type fallback, int fallbackPort) {
        String host;
        Proxy.Type type;
        if (proxyVar == null || proxyVar.trim().length() == 0) {
            return null;
        }
        int port = -1;
        int protoIdx = proxyVar.indexOf(":/");
        if (protoIdx == -1) {
            type = fallback;
        } else {
            String stype = proxyVar.substring(0, protoIdx);
            proxyVar = proxyVar.substring(protoIdx + 2);
            proxyVar = proxyVar.replaceAll("(^/+|/+$)", "");
            type = stype.isEmpty() ? fallback : (stype.startsWith("socks") ? Proxy.Type.SOCKS : Proxy.Type.HTTP);
        }
        int portIdx = proxyVar.lastIndexOf(58);
        if (portIdx == -1) {
            host = proxyVar;
        } else {
            String portStr = proxyVar.substring(portIdx + 1).replaceAll("[^0-9]", "");
            if (!portStr.isEmpty()) {
                port = MiscUtil.parseInt(portStr);
            }
            host = proxyVar.substring(0, portIdx);
        }
        if (port == -1 && fallbackPort > 0) {
            port = fallbackPort;
        }
        if (port < 0 || port > 65535) {
            if (type == Proxy.Type.HTTP) {
                port = 80;
            } else if (type == Proxy.Type.SOCKS) {
                port = 1080;
            }
        }
        return new Proxy(type, InetSocketAddress.createUnresolved(host.trim(), port));
    }

    public static synchronized List<Proxy> noProxyList() {
        if (noProxyList == null) {
            ArrayList<Proxy> list = new ArrayList<Proxy>(1);
            list.add(Proxy.NO_PROXY);
            noProxyList = Collections.unmodifiableList(list);
        }
        return noProxyList;
    }

    public static PacProxySelector buildPacSelectorForUrl(final String url) {
        Logger.log(ProxyUtil.class, Logger.LogLevel.TRACE, "Fetching PAC script from {0}", url);
        final AtomicReference result = new AtomicReference();
        Thread t = new Thread(){

            @Override
            public void run() {
                UrlPacScriptSource pacSource = new UrlPacScriptSource(url);
                if (pacSource.isScriptValid()) {
                    result.set(new PacProxySelector(pacSource));
                }
            }
        };
        t.start();
        try {
            t.join(2500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return (PacProxySelector)result.get();
    }
}

