/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.wpad;

import com.btr.proxy.search.ProxySearchStrategy;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.ProxyUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;

public class WpadProxySearchStrategy
implements ProxySearchStrategy {
    @Override
    public ProxySelector getProxySelector() {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Using WPAD to find a proxy", new Object[0]);
        String pacScriptUrl = this.detectScriptUrlPerDNS();
        if (pacScriptUrl == null) {
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "PAC script url found: {0}", pacScriptUrl);
        return ProxyUtil.buildPacSelectorForUrl(pacScriptUrl);
    }

    public Properties readSettings() {
        String pacScriptUrl = this.detectScriptUrlPerDNS();
        if (pacScriptUrl == null) {
            return null;
        }
        Properties result = new Properties();
        result.setProperty("url", pacScriptUrl);
        return result;
    }

    private String detectScriptUrlPerDNS() {
        int index;
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Searching per DNS guessing.", new Object[0]);
        String ret = this.tryUrl("http://wpad/wpad.dat");
        if (ret != null) {
            return ret;
        }
        String fqdn = null;
        try {
            fqdn = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e2) {
            // empty catch block
        }
        if (fqdn != null && !fqdn.matches("\\d+\\.\\d+\\.\\d+\\.\\d+") && (index = fqdn.indexOf(46)) != -1 && (ret = this.tryUrl("http://wpad." + fqdn.substring(index + 1) + "/wpad.dat")) != null) {
            return ret;
        }
        String[] addresses = null;
        try (FileReader fr = new FileReader("/etc/resolv.conf");
             BufferedReader br = new BufferedReader(fr);){
            String input;
            while ((input = br.readLine()) != null) {
                if (!input.startsWith("search")) continue;
                addresses = input.substring(6).split(" ");
                break;
            }
        }
        catch (IOException e1) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Could not read resolv.conf", new Object[0]);
        }
        if (addresses == null) {
            addresses = new String[]{""};
        }
        for (int i = 0; i < addresses.length; ++i) {
            String address = addresses[i].trim().replaceAll("^\\.+", "").replaceAll("\\.+$", "");
            if (address.length() < 4) continue;
            do {
                if ((ret = this.tryUrl("http://wpad." + address + "/wpad.dat")) == null) continue;
                return ret;
            } while ((index = address.indexOf(46)) != -1 && index + 7 <= address.length() && (address = address.substring(index + 1)).indexOf(46) != -1);
        }
        return null;
    }

    private String tryUrl(String url) {
        try {
            URL lookupURL = new URL(url);
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Trying url: {0}", lookupURL);
            HttpURLConnection con = (HttpURLConnection)lookupURL.openConnection(Proxy.NO_PROXY);
            con.setConnectTimeout(1500);
            con.setReadTimeout(2500);
            con.setRequestMethod("HEAD");
            con.setInstanceFollowRedirects(true);
            con.setRequestProperty("accept", "application/x-ns-proxy-autoconfig");
            if (con.getResponseCode() == 200) {
                String result = lookupURL.toString();
                return result;
            }
            con.disconnect();
        }
        catch (Exception e) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Not available ({0})", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String inputLine;
        WpadProxySearchStrategy wPSS = new WpadProxySearchStrategy();
        try {
            ProxySelector pS = wPSS.getProxySelector();
            ProxySelector.setDefault(pS);
            List<Proxy> proxyList = pS.select(new URI("http://www.google.de"));
            if (proxyList.isEmpty()) {
                Logger.log(WpadProxySearchStrategy.class, Logger.LogLevel.INFO, "ProxyList is empty!", new Object[0]);
            } else {
                Logger.log(WpadProxySearchStrategy.class, Logger.LogLevel.INFO, "proxyList contains: {0}", proxyList.toString());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        URL test = new URL("http://www.google.de");
        URLConnection uc = test.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
        while ((inputLine = br.readLine()) != null) {
            System.out.println(inputLine);
        }
        try (Socket socket = new Socket("www.google.de", 80);){
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            bw.write("GET / HTTP/1.1\r\nHost: www.google.de\r\nConnection: close\r\nAccept-Encoding: *\r\n\r\n");
            bw.flush();
            br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((inputLine = br.readLine()) != null) {
                System.out.println(inputLine);
            }
        }
    }
}

